#version 330
#extension GL_EXT_gpu_shader4 : enable
// yet another mandelbrot zoomermod01.fsh by  biki73
//https://www.shadertoy.com/view/3tSGRD
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.0885  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

vec4 Iter(vec2 ab,float zoom,vec2 trapp) {
int i;
    vec2 xy;
    vec2 xy2;
    vec2 trp;
    xy=vec2(0,0);
    xy2=vec2(0,0);
    float trap=1e30;
    float lxy;
    float t;
    for (i=0;i<1024;i++) {
       xy2=vec2(2.0*(xy.x*xy2.x-xy.y*xy2.y)+1.0,2.0*(xy.x*xy2.y+xy.y*xy2.x));
       xy=vec2(xy.x*xy.x-xy.y*xy.y+ab.x,2.0*xy.x*xy.y+ab.y);
       trp=xy-trapp;
       t=dot(trp,trp);
       if (t<trap) trap=t;
       if (length(xy)>10000.0) break;
    }
    if (i==1024) return vec4(0,0,0,0);
    lxy=length(xy);
    float dis2=2.0*zoom*(lxy/length(xy2))*log(lxy);
    dis2=clamp(dis2,0.0,1.0);
    float clr=0.1*(float(i)-((log(lxy)/log(10000.0))-1.0));
    clr=10.0*sqrt(trap);
    vec4 color=dis2*(vec4(0.5,0.5,0.5,0.66)+0.5*vec4(cos(clr),cos(clr*3.0),cos(clr*7.0),1.0));
    return color;
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord ) 
{
 float zoom=1000000.0*exp(-0.1+3.5*sin(iTime*0.3));
 float rot=iTime*0.5;
 vec2 center=vec2(-0.7490,0.1006+0.0002*sin(iTime*0.0423));
 vec2 trap=vec2(-1.0+0.2*sin(iTime*4.0),-1.0+0.2*cos(iTime*4.0));
 vec2 xy=(gl_FragCoord.xy-(iResolution.xy/2.0))/zoom;

 vec2 xy2=center+vec2(xy.x*cos(rot)-xy.y*sin(rot),xy.x*sin(rot)+xy.y*cos(rot));
 gl_FragColor = Iter(xy2,zoom,trap);
}